clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x) (10*x)+2;  %Gleichung eingeben (innerhalb Integral)
obereGrenze         = 3.0;              %b
untereGrenze        = 0.0;              %a
Quantisierung       = 128;                %n
sKommastellenDouble = '%.8f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
aWERTETABELLE(1,:)=["i","Xi","Rf(h)"];

%BERECHNUNG------------------------------------------------------------------------
dSCHRITTWEITE=(obereGrenze-untereGrenze)/Quantisierung;
aWERTETABELLE(2,1)="0";
aWERTETABELLE(2,2)=num2str(untereGrenze);
aWERTETABELLE(2,3)=num2str(dSCHRITTWEITE*Y(str2double(aWERTETABELLE(2,2))*(dSCHRITTWEITE/2)),sKommastellenDouble);
Zwischenspeicher=0;
for(i=1:1:Quantisierung-1)
    aWERTETABELLE(2+i,1)=num2str(i);
    aWERTETABELLE(2+i,2)=num2str(str2double(aWERTETABELLE(2+i-1,2))+dSCHRITTWEITE,sKommastellenDouble);
    Zwischenspeicher=Zwischenspeicher+Y(str2double(aWERTETABELLE(2+i,2))*(dSCHRITTWEITE/2));
    aWERTETABELLE(2+i,3)=num2str(dSCHRITTWEITE*Zwischenspeicher,sKommastellenDouble);
end
disp(aWERTETABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                               %Workspace aufrumen